<?php
/*  ================================Functions For sql query ================================== */
/******************************************
select_query() 
Just pass needed parameters to this select_query() function & get result from database. We can use join query also.

Parameter :
1) $connect - database connection.
2) Column names - provide 'string with comma separate' like "userid, username, category" .
3) Table name - write 'table name' .
4) Where condition - write 'where' conditions with 'and' keyword like "userid=$id" OR "userid=$id and department='developer' ".
5) Order by - add column name with ASC/ DESC like "username" OR "username DESC".
6) Limit - specify limit of records like "0, 1" OR "10, 20" OR "1".
7) Group by - specify column name like "username"

Note : Please don't use this function if you want to apply having clause condition. 
**********************************************/

function select_query($con, $columns_names, $table_name, $where, $orderby, $limit, $group_by)
{ 
	if(trim($where)!="")
	{
		$where_condition=" WHERE ".$where;
	}
	else
	{
		$where_condition="";
	}  
	if(trim($group_by)!="")
	{
		$group_by_condition=" GROUP BY ".$group_by;
	}
	else
	{
		$group_by_condition="";
	}  
	if(trim($orderby)!="")
	{
		$orderby_condition=" ORDER BY ".$orderby;
	}
	else
	{
		$orderby_condition="";
	} 
	if(trim($limit)!="")
	{
		$limit_condition=" LIMIT ".$limit;
	}
	else
	{
		$limit_condition="";
	}  
	//combination of all clause / conditions --------------------------
	$get_select_query="select $columns_names from $table_name $where_condition $group_by_condition $orderby_condition $limit_condition";
	$get_select_query_sql = mysqli_query($con, $get_select_query) or die(mysqli_error($con));
	
    if(mysqli_num_rows($get_select_query_sql)>0) 
	{ 
		$select_query_return=array();
		while ($get_select_query_rows = mysqli_fetch_assoc($get_select_query_sql))
		{
			$select_query_return[] =$get_select_query_rows;
		}
		return  json_encode($select_query_return);
	}
} 

/**************************
insert_query() 
Just pass needed parameters to this insert_query() function. This function return last inserted id also
 
Parameter :
1) $con - database connection.
2) Column names - provide 'array with comma separate' like array('tickit_number','topic'). //exact column names from table
2) Values - provide 'array with comma separate' like array($_POST['ticket_number'],$_POST['topic']). // variables from GET / POST method. 
3) Table name - write 'table name'. 
**********************/

function insert_query($con, $columns, $values, $table_name) 
{
	if(count($columns)>0 && count($values)>0)
	{
		$columns_in_string = implode(",",$columns); 
		$values_in_string = "'" . implode ( "', '", $values ) . "'"; 
		$insertion_query="insert into $table_name ($columns_in_string) values ($values_in_string) ";
		$insertion_query_sql = mysqli_query($con, $insertion_query) or die(mysqli_error($con));
		
		if ($insertion_query_sql) 
		{ 
			return mysqli_insert_id($con); //return last inserted id
		} 
		else 
		{
			return ""; 
		}
	} 
}
/*****************************************
update_query() - start
// Just pass needed parameters to this update_query() function.

Parameter :
1) $con - database connection.
2) Table name - write 'table name' .
3) Column & value - provide 'string with comma separate' like "generated_by_seen='No', generated_with_seen=''. 
5) Where condition - write 'where' conditions with 'and' keyword like "userid=$id" OR "userid=$id and department='developer' ".
  
**********************/

function update_query($con, $table_name, $columns_values, $where)
{
	if(trim($columns_values)!="")
	{
		if(trim($where)!="")
		{
			$where_condition=" WHERE ".$where;
		}
		else
		{
			$where_condition="";
		}  
		 
		$update_query="update $table_name set $columns_values $where_condition ";
		$update_query_sql = mysqli_query($con, $update_query) or die(mysqli_error($con));
		
		if ($update_query_sql) 
		{ 
			return true;  
		} 
		else 
		{
			return false; 
		} 
	} 
}

/*************************
delete_query()
// Just pass needed parameters to this delete_query() function.

Parameter :
1) $con - database connection.
2) Table name - write 'table name' .
3) Where condition - write 'where' conditions with 'and' keyword like "userid=$id" OR "userid=$id and department='developer' ".
  
**********************/
function delete_query($con, $table_name, $where)
{ 
	if(trim($where)!="")
	{
		$where_condition=" WHERE ".$where;
	}
	else
	{
		$where_condition="";
	}  
	 
    $delete_query="delete from  $table_name  $where_condition ";
	$delete_query_sql = mysqli_query($con, $delete_query) or die(mysqli_error($con));
	
	if ($delete_query_sql) 
	{ 
		return true;  
	} 
	else 
	{
		return false; 
	}  
} 

function encryption($value)
{
	$rand_number=(rand(1000,9999));
	$str = 'abcdefghijklmnopqustuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
	$rand_char=substr(str_shuffle($str), 0, 4);
	$ascii = "";
	for ($i = 0; $i < strlen($rand_char); $i++) 
	{ 
		$ascii .= ord($rand_char[$i]); 
	}
	return $final_result=$rand_char."".(($value*$rand_number)+$ascii)."".$rand_number;
}
	
function decryption($value)
{
	$ascii = "";
	for ($i = 0; $i < strlen(substr($value, 0, 4)); $i++) 
	{ 
		$ascii .= ord(substr($value, 0, 4)[$i]); 
	}
	return ((substr($value,4, -4))-$ascii)/(substr($value, -4));
}

?>