<?php
//To SANITIZE only alphabets and spaces value
function StringAlphaSpaceCleaner($data)
{
	//remove space bfore and after
	$data = trim($data); 
	//remove slashes
	$data = stripslashes($data); 
	$data=(filter_var($data, FILTER_SANITIZE_STRING));
	$data = preg_replace("/[^A-Za-z ]/",'',$data);
	return $data;
}

//To SANITIZE only alphabets 
function StringAlphaCleaner($data)
{
	//remove space bfore and after
	$data = trim($data); 
	//remove slashes
	$data = stripslashes($data); 
	$data=(filter_var($data, FILTER_SANITIZE_STRING));
	$data = preg_replace("/[^A-Za-z]/",'',$data);
	return $data;
}

//To SANITIZE only alphabets and Numeric value
function StringAlphaNumericCleaner($data)
{
	//remove space bfore and after
	$data = trim($data); 
	//remove slashes
	$data = stripslashes($data); 
	$data=(filter_var($data, FILTER_SANITIZE_STRING));
	$data = preg_replace("/[^A-Za-z0-9]/",'',$data);
	return $data;
}

//To SANITIZE String value
function StringCleaner($data)
{
	//remove space bfore and after
	$data = trim($data); 
	//remove slashes
	$data = stripslashes($data); 
	$data=(filter_var($data, FILTER_SANITIZE_STRING));
	return $data;
}

//To SANITIZE email
function EmailCleaner($Email)
{
	$Email = trim($Email); 
	$Email=(filter_var($Email,  FILTER_SANITIZE_EMAIL));
	return $Email;
}


// To SANITIZE Integer value
function NumberCleaner($Number)
{
	$Number = trim($Number); 
	$Number=(filter_var($Number, FILTER_SANITIZE_NUMBER_INT));
	$Number=preg_replace("/[^0-9]/",'',$Number);
	return $Number;
}

// To SANITIZE Float value
function FloatNumberCleaner($Number)
{
	$Number = trim($Number);
	$floatNumber=(filter_var($Number, FILTER_SANITIZE_NUMBER_FLOAT,FILTER_FLAG_ALLOW_FRACTION));
	$floatNumber=preg_replace("/[^0-9.]/",'',$floatNumber);
	return $floatNumber;
}

// To SANITIZE Date value
function DateCleaner($date)
{
	$date = trim($date); 
	$date = stripslashes($date); 
	$date=(filter_var($date, FILTER_SANITIZE_STRING));
	$date = preg_replace("([^0-9/-])", "", $date);
	return $date;
}
?>